###################################################
### code chunk number : Power-log loss function
###################################################
## 
##
## L[pl](x)
rm(list=ls(all=TRUE))
theta = 0.2
n = 10
L_pl_x = function(x) (1/theta - 1)^2 / (1/theta - x) - log(x) - (1/theta - 1)
k1_theta = theta * (1/theta - 1)^2; k1_theta
x = seq(exp(-k1_theta * n), 1/theta * (1 - 1/n), length.out = 1000)
y = L_pl_x(x) 
# xp = c(exp(-k1_theta * (n:2)), 1, 1/theta * (1 - 1 / (2:n)))
# yp = L_pl_x(xp)
xlim = c(0, 1/theta)
plot(x, y, xlab = expression( x ), ylab = expression( L[pl](x) ), xlim = xlim, type = "l", lwd = 4, sub = "(a)")
# points(xp, yp, pch = c((n-1):1, 0, 1:(n-1)), col = "red", lwd = 2)
abline(h = 0, lty = "dashed")
abline(v = c(0, 1/theta), lty = "dashed")
savePlot(filename = "figure/y_pl_x", type = c("pdf"))
savePlot(filename = "figure/y_pl_x", type = c("jpg"))


## L[pl](theta, a)
rm(list=ls(all=TRUE))
theta = 0.2
n = 10
L_pl_a = function(theta, a) theta * (1/theta - 1)^2 / (1 - a) - log(a) + log(theta) - (1/theta - 1)
k2_theta = theta * (1/theta - 1)^2; k2_theta ## k2_theta = k1_theta
a = seq(theta * exp(-k2_theta * n), (1 - 1/n), length.out = 1000)
y = L_pl_a(theta, a) 
# ap = c(theta * exp(-k2_theta * (n:2)), theta, 1 - 1 / (2:n))
# yp = L_pl_a(theta, ap)
xlim = c(0, 1)
dev.new()
plot(a, y, xlab = expression( a ), ylab = expression( paste(L[pl], "(", theta, ", a)") ), xlim = xlim, type = "l", lwd = 4, sub = "(b)")
# points(ap, yp, pch = c((n-1):1, 0, 1:(n-1)), col = "red", lwd = 2)
abline(h = 0, lty = "dashed")
abline(v = c(0, 1), lty = "dashed")
savePlot(filename = "figure/y_pl_theta_a", type = c("pdf"))
savePlot(filename = "figure/y_pl_theta_a", type = c("jpg"))


###################################################
### code chunk number : Zhang's loss function
###################################################
## 
## (a): L_z(x)
rm(list=ls(all=TRUE))
theta = 0.2
n = 10
L_z_x = function(x) 1/((1/theta - 1)^2 * x) + 1/(1/theta - x) - 1/ (theta * (1/theta - 1)^2)
k1_theta = 1/(theta * (1/theta - 1)^2); k1_theta
x = seq(k1_theta * 1/n, 1/theta * (1 - 1/n), length.out = 50)
y = L_z_x(x) 
xp = c(k1_theta * 1 / (n:2), 1, 1/theta * (1 - 1 / (2:n)))
yp = L_z_x(xp)
xlim = c(0, 1/theta)
plot(x, y, xlab = expression( x ), ylab = expression( L[z](x) ), xlim = xlim, type = "l", lwd = 4, sub = "(a)")
points(xp, yp, pch = c((n-1):1, 0, 1:(n-1)), col = "red", lwd = 2, cex = 2)
abline(h = 0, lty = "dashed")
abline(v = 1/theta, lty = "dashed")
savePlot(filename = "figure/y_z_x", type = c("pdf"))
savePlot(filename = "figure/y_z_x", type = c("jpg"))

## L(theta, a)
rm(list=ls(all=TRUE))
theta = 0.2
n = 10
L_z_a = function(theta, a) theta/((1/theta - 1)^2 * a) + theta/(1 - a) - 1/ (theta * (1/theta - 1)^2)
k2_theta = 1/((1/theta - 1)^2); k2_theta
a = seq(k2_theta * 1/n, (1 - 1/n), length.out = 50)
y = L_z_a(theta, a) 
ap = c(k2_theta * 1 / (n:2), theta, 1 - 1 / (2:n))
yp = L_z_a(theta, ap)
xlim = c(0, 1)
dev.new()
plot(a, y, xlab = expression( a ), ylab = expression( paste(L[z], "(", theta, ", a)") ), xlim = xlim, type = "l", lwd = 4, sub = "(b)")
points(ap, yp, pch = c((n-1):1, 0, 1:(n-1)), col = "red", lwd = 2, cex = 2)
abline(h = 0, lty = "dashed")
abline(v = 1, lty = "dashed")
savePlot(filename = "figure/y_z_theta_a", type = c("pdf"))
savePlot(filename = "figure/y_z_theta_a", type = c("jpg"))


###################################################
### code chunk number : LINEX loss function
###################################################
## 
## (a): L_LINEX(x) with c = 1
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
c = 1 # > 0
theta_1 = -2
theta_2 = -0.5
theta_3 = 0.5
theta_4 = 2
y_LINEX_x_c_theta_1 = exp(c * theta_1 * (x - 1)) - c * theta_1 * (x - 1) - 1
y_LINEX_x_c_theta_2 = exp(c * theta_2 * (x - 1)) - c * theta_2 * (x - 1) - 1
y_LINEX_x_c_theta_3 = exp(c * theta_3 * (x - 1)) - c * theta_3 * (x - 1) - 1
y_LINEX_x_c_theta_4 = exp(c * theta_4 * (x - 1)) - c * theta_4 * (x - 1) - 1

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:4
col = c("blue", "red", "purple", "black")
ylim = c(0, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_LINEX_x_c_theta_1, ylim = ylim, xlab = expression( x ), ylab = expression( L[LINEX](x) ), type = "n", lwd = 4, main = "c = 1", sub = "(a)")
lines(x, y_LINEX_x_c_theta_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_LINEX_x_c_theta_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_LINEX_x_c_theta_3, lty = lty[3], col = col[3], lwd = 4)
lines(x, y_LINEX_x_c_theta_4, lty = lty[4], col = col[4], lwd = 4)
leg.txt = c(
expression( paste(theta, " = -2") ), 
expression( paste(theta, " = -0.5") ),
expression( paste(theta, " = 0.5") ),
expression( paste(theta, " = 2") )
)
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_LINEX_x_c_1_theta_1234", type = c("pdf"))
savePlot(filename = "figure/y_LINEX_x_c_1_theta_1234", type = c("jpg"))


## (b): L_LINEX(x) with c = -1
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
c = -1 # < 0
theta_1 = -2
theta_2 = -0.5
theta_3 = 0.5
theta_4 = 2
y_LINEX_x_c_theta_1 = exp(c * theta_1 * (x - 1)) - c * theta_1 * (x - 1) - 1
y_LINEX_x_c_theta_2 = exp(c * theta_2 * (x - 1)) - c * theta_2 * (x - 1) - 1
y_LINEX_x_c_theta_3 = exp(c * theta_3 * (x - 1)) - c * theta_3 * (x - 1) - 1
y_LINEX_x_c_theta_4 = exp(c * theta_4 * (x - 1)) - c * theta_4 * (x - 1) - 1

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:4
col = c("blue", "red", "purple", "black")
ylim = c(0, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_LINEX_x_c_theta_1, ylim = ylim, xlab = expression( x ), ylab = expression( L[LINEX](x) ), type = "n", lwd = 4, main = "c = -1", sub = "(b)")
lines(x, y_LINEX_x_c_theta_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_LINEX_x_c_theta_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_LINEX_x_c_theta_3, lty = lty[3], col = col[3], lwd = 4)
lines(x, y_LINEX_x_c_theta_4, lty = lty[4], col = col[4], lwd = 4)
leg.txt = c(
expression( paste(theta, " = -2") ), 
expression( paste(theta, " = -0.5") ),
expression( paste(theta, " = 0.5") ),
expression( paste(theta, " = 2") )
)
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_LINEX_x_c_m1_theta_1234", type = c("pdf"))
savePlot(filename = "figure/y_LINEX_x_c_m1_theta_1234", type = c("jpg"))


## (c): L_LINEX(theta, a) with theta = 2
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
c_1 = 1
c_2 = -1
y_LINEX_theta_a_c_1 = exp(c_1 * (a - theta)) - c_1 * (a - theta) - 1
y_LINEX_theta_a_c_2 = exp(c_2 * (a - theta)) - c_2 * (a - theta) - 1

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:2
col = c("blue", "red")
ylim = c(0, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_LINEX_theta_a_c_1, ylim = ylim, xlab = expression( a ), ylab = expression( L[LINEX](theta, a) ), type = "n", lwd = 4, main = expression( paste(theta, " = 2") ), sub = "(c)")
lines(a, y_LINEX_theta_a_c_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_LINEX_theta_a_c_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c(
expression( paste(c, " = 1") ), 
expression( paste(c, " = -1") )
)
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_LINEX_theta_2_a_c_12", type = c("pdf"))
savePlot(filename = "figure/y_LINEX_theta_2_a_c_12", type = c("jpg"))


## (d): L_LINEX(theta, a) with theta = 0.5
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
c_1 = 1
c_2 = -1
y_LINEX_theta_a_c_1 = exp(c_1 * (a - theta)) - c_1 * (a - theta) - 1
y_LINEX_theta_a_c_2 = exp(c_2 * (a - theta)) - c_2 * (a - theta) - 1

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:2
col = c("blue", "red")
ylim = c(0, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_LINEX_theta_a_c_1, ylim = ylim, xlab = expression( a ), ylab = expression( L[LINEX](theta, a) ), type = "n", lwd = 4, main = expression( paste(theta, " = 0.5") ), sub = "(d)")
lines(a, y_LINEX_theta_a_c_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_LINEX_theta_a_c_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c(
expression( paste(c, " = 1") ), 
expression( paste(c, " = -1") )
)
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_LINEX_theta_0p5_a_c_12", type = c("pdf"))
savePlot(filename = "figure/y_LINEX_theta_0p5_a_c_12", type = c("jpg"))


###################################################
### code chunk number : Weighted absolute error loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(-3, 5, by = 0.01)
y_wae_x = abs(x - 1)

# xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
# y_wae_xp = abs(xp - 1)

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_wae_x, xlab = expression( x ), ylab = expression( L[1](x) ), type = "l", lwd = 4, sub = "(a)")
# points(xp, y_wae_xp, pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4), col = "red", lwd = 4)
par(opar)
savePlot(filename = "figure/y_wae_x", type = c("pdf"))
savePlot(filename = "figure/y_wae_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_wae_theta_1_a = abs(a / theta_1 - 1)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_wae_theta_1_a, xlab = expression( a ), ylab = expression( L[1](theta, a) ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_wae_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_wae_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_wae_theta_2_a = abs(a / theta_2 - 1)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_wae_theta_2_a, xlab = expression( a ), ylab = expression( L[1](theta, a) ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_wae_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_wae_theta_2_a", type = c("jpg"))



###################################################
### code chunk number : Weighted squared error loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(-3, 5, by = 0.01)
y_wse_x = (x - 1)^2

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_wse_x, xlab = expression( x ), ylab = expression( L[2](x) ), type = "l", lwd = 4, sub = "(a)")
par(opar)
savePlot(filename = "figure/y_wse_x", type = c("pdf"))
savePlot(filename = "figure/y_wse_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_wse_theta_1_a = (a / theta_1 - 1)^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_wse_theta_1_a, xlab = expression( a ), ylab = expression( L[2](theta, a) ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_wse_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_wse_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_wse_theta_2_a = (a / theta_2 - 1)^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_wse_theta_2_a, xlab = expression( a ), ylab = expression( L[2](theta, a) ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_wse_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_wse_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : Absolute error loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(-3, 5, by = 0.01)
theta_1 = 2
y_ae_x_theta_1 = abs(theta_1) * abs(x - 1)

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_ae_x_theta_1, xlab = expression( x ), ylab = expression( tilde(L)[1](x) ), type = "l", lwd = 4, sub = "(a)")
par(opar)
savePlot(filename = "figure/y_ae_x_theta_1", type = c("pdf"))
savePlot(filename = "figure/y_ae_x_theta_1", type = c("jpg"))

theta_2 = 0.5
y_ae_x_theta_2 = abs(theta_2) * abs(x - 1)

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_ae_x_theta_2, xlab = expression( x ), ylab = expression( tilde(L)[1](x) ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_ae_x_theta_2", type = c("pdf"))
savePlot(filename = "figure/y_ae_x_theta_2", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_ae_theta_1_a = abs(a - theta_1)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_ae_theta_1_a, xlab = expression( a ), ylab = expression( tilde(L)[1](theta, a) ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_ae_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_ae_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_ae_theta_2_a = abs(a - theta_2)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_ae_theta_2_a, xlab = expression( a ), ylab = expression( tilde(L)[1](theta, a) ), type = "l", lwd = 4, sub = "(d)")
par(opar)
savePlot(filename = "figure/y_ae_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_ae_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : Squared error loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(-3, 5, by = 0.01)
theta_1 = 2
y_se_x_theta_1 = theta_1^2 * (x - 1)^2

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_se_x_theta_1, xlab = expression( x ), ylab = expression( tilde(L)[2](x) ), type = "l", lwd = 4, sub = "(a)")
par(opar)
savePlot(filename = "figure/y_se_x_theta_1", type = c("pdf"))
savePlot(filename = "figure/y_se_x_theta_1", type = c("jpg"))

theta_2 = 0.5
y_se_x_theta_2 = theta_2^2 * (x - 1)^2

dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_se_x_theta_2, xlab = expression( x ), ylab = expression( tilde(L)[2](x) ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_se_x_theta_2", type = c("pdf"))
savePlot(filename = "figure/y_se_x_theta_2", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_se_theta_1_a = (a - theta_1)^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_se_theta_1_a, xlab = expression( a ), ylab = expression( tilde(L)[2](theta, a) ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_se_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_se_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_se_theta_2_a = (a - theta_2)^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_se_theta_2_a, xlab = expression( a ), ylab = expression( tilde(L)[2](theta, a) ), type = "l", lwd = 4, sub = "(d)")
par(opar)
savePlot(filename = "figure/y_se_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_se_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : log-1 loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(0.2, 5, by = 0.01)
y_log_1_x = abs(log(x))

xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
y_log_1_xp = abs(log(xp))

# mar = c(bottom, left, top, right)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_log_1_x, xlab = expression( x ), ylab = expression( paste(L[l]^{1}, (x)) ), type = "l", lwd = 4, sub = "(a)")
points(xp, y_log_1_xp, pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4), col = "red", lwd = 4, cex = 2)
par(opar)
savePlot(filename = "figure/y_log_1_x", type = c("pdf"))
savePlot(filename = "figure/y_log_1_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_log_1_theta_1_a = abs(log(a / theta_1))
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_log_1_theta_1_a, xlab = expression( a ), ylab = expression( paste(L[l]^{1}, "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_log_1_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_log_1_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_log_1_theta_2_a = abs(log(a / theta_2))
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_log_1_theta_2_a, xlab = expression( a ), ylab = expression( paste(L[l]^{1}, "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_log_1_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_log_1_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : log-2 loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(0.2, 5, by = 0.01)
y_log_2_x = (log(x))^2

xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
y_log_2_xp = log(xp)^2

# mar = c(bottom, left, top, right)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_log_2_x, xlab = expression( x ), ylab = expression( paste(L[l]^{2}, (x)) ), type = "l", lwd = 4, sub = "(a)")
points(xp, y_log_2_xp, pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4), col = "red", lwd = 4, cex = 2)
par(opar)
savePlot(filename = "figure/y_log_2_x", type = c("pdf"))
savePlot(filename = "figure/y_log_2_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_log_2_theta_1_a = (log(a / theta_1))^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_log_2_theta_1_a, xlab = expression( a ), ylab = expression( paste(L[l]^{2}, "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_log_2_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_log_2_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_log_2_theta_2_a = (log(a / theta_2))^2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_log_2_theta_2_a, xlab = expression( a ), ylab = expression( paste(L[l]^{2}, "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_log_2_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_log_2_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : Stein's loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(0.035, 5, by = 0.01)
y_s_x = x - log(x) - 1

# mar = c(bottom, left, top, right)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_s_x, xlab = expression( x ), ylab = expression( L[s](x) ), type = "l", lwd = 4, sub = "(a)")
par(opar)
savePlot(filename = "figure/y_s_x", type = c("pdf"))
savePlot(filename = "figure/y_s_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_s_theta_1_a = a / theta_1 - log(a / theta_1) - 1
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_s_theta_1_a, xlab = expression( a ), ylab = expression( paste(L[s], "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_s_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_s_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_s_theta_2_a = a / theta_2 - log(a / theta_2) - 1
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_s_theta_2_a, xlab = expression( a ), ylab = expression( paste(L[s], "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_s_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_s_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : Power-power loss function
###################################################
## 
rm(list=ls(all=TRUE))

x = seq(0.2, 5, by = 0.01)
y_pp_x = x + 1/x - 2

xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
y_pp_xp = xp + 1/xp - 2

# mar = c(bottom, left, top, right)
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_pp_x, xlab = expression( x ), ylab = expression( L[p](x) ), type = "l", lwd = 4, sub = "(a)")
points(xp, y_pp_xp, pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4), col = "red", lwd = 4, cex = 2)
par(opar)
savePlot(filename = "figure/y_pp_x", type = c("pdf"))
savePlot(filename = "figure/y_pp_x", type = c("jpg"))

theta_1 = 2
a = theta_1 * x
y_pp_theta_1_a = a / theta_1 + theta_1 / a - 2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_pp_theta_1_a, xlab = expression( a ), ylab = expression( paste(L[p], "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(b)")
par(opar)
savePlot(filename = "figure/y_pp_theta_1_a", type = c("pdf"))
savePlot(filename = "figure/y_pp_theta_1_a", type = c("jpg"))

theta_2 = 0.5
a = theta_2 * x
y_pp_theta_2_a = a / theta_2 + theta_2 / a - 2
dev.new()
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_pp_theta_2_a, xlab = expression( a ), ylab = expression( paste(L[p], "(", theta, ", a)") ), type = "l", lwd = 4, sub = "(c)")
par(opar)
savePlot(filename = "figure/y_pp_theta_2_a", type = c("pdf"))
savePlot(filename = "figure/y_pp_theta_2_a", type = c("jpg"))


###################################################
### code chunk number : Generalized Stein's loss function
###################################################
## 


##############
### L_gs(x)
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gs_x_alpha_1 = k0 * x^alpha_1 - k1 * log(x^beta) - k0
y_gs_x_alpha_2 = k0 * x^alpha_2 - k1 * log(x^beta) - k0
y_gs_x_alpha_3 = k0 * x^alpha_3 - k1 * log(x^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gs_x_alpha_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(a)")
lines(x, y_gs_x_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gs_x_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gs_x_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_x_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_x_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gs_x_beta_1 = k0 * x^alpha - k1 * log(x^beta_1) - k0
y_gs_x_beta_2 = k0 * x^alpha - k1 * log(x^beta_2) - k0
y_gs_x_beta_3 = k0 * x^alpha - k1 * log(x^beta_3) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gs_x_beta_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(b)")
lines(x, y_gs_x_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gs_x_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gs_x_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_x_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_x_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gs_x_k0_1 = k0_1 * x^alpha - k1 * log(x^beta) - k0_1
y_gs_x_k0_2 = k0_2 * x^alpha - k1 * log(x^beta) - k0_2
y_gs_x_k0_3 = k0_3 * x^alpha - k1 * log(x^beta) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gs_x_k0_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(c)")
lines(x, y_gs_x_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gs_x_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gs_x_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_x_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_x_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
# alpha = beta = 1; k0 = 2
y_gs_x_k1_1 = k0 * x^alpha - k1_1 * log(x^beta) - k0
y_gs_x_k1_2 = k0 * x^alpha - k1_2 * log(x^beta) - k0
y_gs_x_k1_3 = k0 * x^alpha - k1_3 * log(x^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gs_x_k1_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(d)")
lines(x, y_gs_x_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gs_x_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gs_x_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_x_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_x_k1_123", type = c("jpg"))


##############
### k0 * alpha = k1 * beta
##############
## 

## (a): L_gs(x) with three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gs_x_set_1 = k0_1 * x^alpha_1 - k1_1 * log(x^beta_1) - k0_1
y_gs_x_set_2 = k0_2 * x^alpha_2 - k1_2 * log(x^beta_2) - k0_2
y_gs_x_set_3 = k0_3 * x^alpha_3 - k1_3 * log(x^beta_3) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gs_x_set_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(a)")
lines(x, y_gs_x_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gs_x_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gs_x_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_x_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_x_set_123", type = c("jpg"))


## (b): L_gs(theta, a) with theta = 2 and three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 2
a = theta * x
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gs_theta_a_set_1 = k0_1 * x^alpha_1 - k1_1 * log(x^beta_1) - k0_1
y_gs_theta_a_set_2 = k0_2 * x^alpha_2 - k1_2 * log(x^beta_2) - k0_2
y_gs_theta_a_set_3 = k0_3 * x^alpha_3 - k1_3 * log(x^beta_3) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_set_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gs_theta_a_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_2_a_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_2_a_set_123", type = c("jpg"))


## (c): L_gs(theta, a) with theta = 0.5 and three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 0.5
a = theta * x
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gs_theta_a_set_1 = k0_1 * x^alpha_1 - k1_1 * log(x^beta_1) - k0_1
y_gs_theta_a_set_2 = k0_2 * x^alpha_2 - k1_2 * log(x^beta_2) - k0_2
y_gs_theta_a_set_3 = k0_3 * x^alpha_3 - k1_3 * log(x^beta_3) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_set_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gs_theta_a_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_0p5_a_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_0p5_a_set_123", type = c("jpg"))


##############
### L_gs(theta, a) with theta = 2, not used
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 2
a = theta * x
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gs_theta_a_alpha_1 = k0 * (a / theta)^alpha_1 - k1 * log((a / theta)^beta) - k0
y_gs_theta_a_alpha_2 = k0 * (a / theta)^alpha_2 - k1 * log((a / theta)^beta) - k0
y_gs_theta_a_alpha_3 = k0 * (a / theta)^alpha_3 - k1 * log((a / theta)^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_alpha_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(a)")
lines(a, y_gs_theta_a_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_2_a_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_2_a_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 2
a = theta * x
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gs_theta_a_beta_1 = k0 * x^alpha - k1 * log(x^beta_1) - k0
y_gs_theta_a_beta_2 = k0 * x^alpha - k1 * log(x^beta_2) - k0
y_gs_theta_a_beta_3 = k0 * x^alpha - k1 * log(x^beta_3) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_beta_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gs_theta_a_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_2_a_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_2_a_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 2
a = theta * x
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gs_theta_a_k0_1 = k0_1 * x^alpha - k1 * log(x^beta) - k0_1
y_gs_theta_a_k0_2 = k0_2 * x^alpha - k1 * log(x^beta) - k0_2
y_gs_theta_a_k0_3 = k0_3 * x^alpha - k1 * log(x^beta) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_k0_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gs_theta_a_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_2_a_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_2_a_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 2
a = theta * x
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
y_gs_theta_a_k1_1 = k0 * x^alpha - k1_1 * log(x^beta) - k0
y_gs_theta_a_k1_2 = k0 * x^alpha - k1_2 * log(x^beta) - k0
y_gs_theta_a_k1_3 = k0 * x^alpha - k1_3 * log(x^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_k1_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(d)")
lines(a, y_gs_theta_a_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_2_a_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_2_a_k1_123", type = c("jpg"))


##############
### L_gs(theta, a) with theta = 0.5, not used
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 0.5
a = theta * x
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gs_theta_a_alpha_1 = k0 * (a / theta)^alpha_1 - k1 * log((a / theta)^beta) - k0
y_gs_theta_a_alpha_2 = k0 * (a / theta)^alpha_2 - k1 * log((a / theta)^beta) - k0
y_gs_theta_a_alpha_3 = k0 * (a / theta)^alpha_3 - k1 * log((a / theta)^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_alpha_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(a)")
lines(a, y_gs_theta_a_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_0p5_a_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_0p5_a_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 0.5
a = theta * x
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gs_theta_a_beta_1 = k0 * x^alpha - k1 * log(x^beta_1) - k0
y_gs_theta_a_beta_2 = k0 * x^alpha - k1 * log(x^beta_2) - k0
y_gs_theta_a_beta_3 = k0 * x^alpha - k1 * log(x^beta_3) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_beta_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gs_theta_a_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_0p5_a_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_0p5_a_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 0.5
a = theta * x
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gs_theta_a_k0_1 = k0_1 * x^alpha - k1 * log(x^beta) - k0_1
y_gs_theta_a_k0_2 = k0_2 * x^alpha - k1 * log(x^beta) - k0_2
y_gs_theta_a_k0_3 = k0_3 * x^alpha - k1 * log(x^beta) - k0_3

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_k0_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gs_theta_a_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_0p5_a_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_0p5_a_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.035, 5, by = 0.01)
theta = 0.5
a = theta * x
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
y_gs_theta_a_k1_1 = k0 * x^alpha - k1_1 * log(x^beta) - k0
y_gs_theta_a_k1_2 = k0 * x^alpha - k1_2 * log(x^beta) - k0
y_gs_theta_a_k1_3 = k0 * x^alpha - k1_3 * log(x^beta) - k0

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gs_theta_a_k1_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[s]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(d)")
lines(a, y_gs_theta_a_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gs_theta_a_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gs_theta_a_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gs_theta_0p5_a_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gs_theta_0p5_a_k1_123", type = c("jpg"))


###################################################
### code chunk number : Generalized power-power loss function
###################################################
## 


##############
### L_gpp(x)
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gpp_x_alpha_1 = k0 * x^alpha_1 + k1 / x^beta - (k0 + k1)
y_gpp_x_alpha_2 = k0 * x^alpha_2 + k1 / x^beta - (k0 + k1)
y_gpp_x_alpha_3 = k0 * x^alpha_3 + k1 / x^beta - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gpp_x_alpha_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(a)")
lines(x, y_gpp_x_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gpp_x_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gpp_x_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_x_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_x_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gpp_x_beta_1 = k0 * x^alpha + k1 / x^beta_1 - (k0 + k1)
y_gpp_x_beta_2 = k0 * x^alpha + k1 / x^beta_2 - (k0 + k1)
y_gpp_x_beta_3 = k0 * x^alpha + k1 / x^beta_3 - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gpp_x_beta_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(b)")
lines(x, y_gpp_x_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gpp_x_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gpp_x_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_x_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_x_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gpp_x_k0_1 = k0_1 * x^alpha + k1 / x^beta - (k0_1 + k1)
y_gpp_x_k0_2 = k0_2 * x^alpha + k1 / x^beta - (k0_2 + k1)
y_gpp_x_k0_3 = k0_3 * x^alpha + k1 / x^beta - (k0_3 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gpp_x_k0_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(c)")
lines(x, y_gpp_x_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gpp_x_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gpp_x_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_x_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_x_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
# alpha = beta = 1; k0 = 2
y_gpp_x_k1_1 = k0 * x^alpha + k1_1 / x^beta - (k0 + k1_1)
y_gpp_x_k1_2 = k0 * x^alpha + k1_2 / x^beta - (k0 + k1_2)
y_gpp_x_k1_3 = k0 * x^alpha + k1_3 / x^beta - (k0 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gpp_x_k1_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(d)")
lines(x, y_gpp_x_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gpp_x_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gpp_x_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_x_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_x_k1_123", type = c("jpg"))


##############
### k0 * alpha = k1 * beta
##############
## 

## (a): L_gpp(x) with three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gpp_x_set_1 = k0_1 * x^alpha_1 + k1_1 / x^beta_1 - (k0_1 + k1_1)
y_gpp_x_set_2 = k0_2 * x^alpha_2 + k1_2 / x^beta_2 - (k0_2 + k1_2)
y_gpp_x_set_3 = k0_3 * x^alpha_3 + k1_3 / x^beta_3 - (k0_3 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(x, y_gpp_x_set_1, ylim = ylim, xlab = expression( x ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, (x)) ), type = "l", lwd = 4, sub = "(a)")
lines(x, y_gpp_x_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(x, y_gpp_x_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(x, y_gpp_x_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_x_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_x_set_123", type = c("jpg"))


## (b): L_gpp(theta, a) with theta = 2 and three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gpp_theta_a_set_1 = k0_1 * x^alpha_1 + k1_1 / x^beta_1 - (k0_1 + k1_1)
y_gpp_theta_a_set_2 = k0_2 * x^alpha_2 + k1_2 / x^beta_2 - (k0_2 + k1_2)
y_gpp_theta_a_set_3 = k0_3 * x^alpha_3 + k1_3 / x^beta_3 - (k0_3 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_set_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gpp_theta_a_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_2_a_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_2_a_set_123", type = c("jpg"))


## (c): L_gpp(theta, a) with theta = 0.5 and three parameter sets
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
alpha_1 = 1;   beta_1 = 1;   k0_1 = 1;   k1_1 = 1
alpha_2 = 2;   beta_2 = 2;   k0_2 = 1/2; k1_2 = 1/2
alpha_3 = 1/2; beta_3 = 1/2; k0_3 = 2;   k1_3 = 2
y_gpp_theta_a_set_1 = k0_1 * x^alpha_1 + k1_1 / x^beta_1 - (k0_1 + k1_1)
y_gpp_theta_a_set_2 = k0_2 * x^alpha_2 + k1_2 / x^beta_2 - (k0_2 + k1_2)
y_gpp_theta_a_set_3 = k0_3 * x^alpha_3 + k1_3 / x^beta_3 - (k0_3 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 3)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_set_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gpp_theta_a_set_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_set_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_set_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1, 1, 1, 1)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (2, 2, 1/2, 1/2)") ), 
expression( paste(group("(", list(alpha, beta, k[0], k[1]), ")"), " = (1/2, 1/2, 2, 2)") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_0p5_a_set_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_0p5_a_set_123", type = c("jpg"))


##############
### L_gpp(theta, a) with theta = 2, not used
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gpp_theta_a_alpha_1 = k0 * x^alpha_1 + k1 / x^beta - (k0 + k1)
y_gpp_theta_a_alpha_2 = k0 * x^alpha_2 + k1 / x^beta - (k0 + k1)
y_gpp_theta_a_alpha_3 = k0 * x^alpha_3 + k1 / x^beta - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_alpha_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(a)")
lines(a, y_gpp_theta_a_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_2_a_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_2_a_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gpp_theta_a_beta_1 = k0 * x^alpha + k1 / x^beta_1 - (k0 + k1)
y_gpp_theta_a_beta_2 = k0 * x^alpha + k1 / x^beta_2 - (k0 + k1)
y_gpp_theta_a_beta_3 = k0 * x^alpha + k1 / x^beta_3 - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_beta_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gpp_theta_a_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_2_a_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_2_a_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gpp_theta_a_k0_1 = k0_1 * x^alpha + k1 / x^beta - (k0_1 + k1)
y_gpp_theta_a_k0_2 = k0_2 * x^alpha + k1 / x^beta - (k0_2 + k1)
y_gpp_theta_a_k0_3 = k0_3 * x^alpha + k1 / x^beta - (k0_3 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_k0_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gpp_theta_a_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_2_a_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_2_a_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 2
a = theta * x
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
# alpha = beta = 1; k0 = 2
y_gpp_theta_a_k1_1 = k0 * x^alpha + k1_1 / x^beta - (k0 + k1_1)
y_gpp_theta_a_k1_2 = k0 * x^alpha + k1_2 / x^beta - (k0 + k1_2)
y_gpp_theta_a_k1_3 = k0 * x^alpha + k1_3 / x^beta - (k0 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_k1_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(d)")
lines(a, y_gpp_theta_a_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_2_a_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_2_a_k1_123", type = c("jpg"))


##############
### L_gpp(theta, a) with theta = 0.5, not used
##############
## 

## (a): alpha changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
alpha_1 = 0.5
alpha_2 = 1
alpha_3 = 2
beta = k0 = k1 = 1
y_gpp_theta_a_alpha_1 = k0 * x^alpha_1 + k1 / x^beta - (k0 + k1)
y_gpp_theta_a_alpha_2 = k0 * x^alpha_2 + k1 / x^beta - (k0 + k1)
y_gpp_theta_a_alpha_3 = k0 * x^alpha_3 + k1 / x^beta - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_alpha_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(a)")
lines(a, y_gpp_theta_a_alpha_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_alpha_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_alpha_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(alpha, " = 0.5") ), 
expression( paste(alpha, " = 1") ),
expression( paste(alpha, " = 2") )
)
legend("right", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_0p5_a_alpha_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_0p5_a_alpha_123", type = c("jpg"))


## (b): beta changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
beta_1 = 0.5
beta_2 = 1
beta_3 = 2
alpha = k0 = k1 = 1
y_gpp_theta_a_beta_1 = k0 * x^alpha + k1 / x^beta_1 - (k0 + k1)
y_gpp_theta_a_beta_2 = k0 * x^alpha + k1 / x^beta_2 - (k0 + k1)
y_gpp_theta_a_beta_3 = k0 * x^alpha + k1 / x^beta_3 - (k0 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_beta_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(b)")
lines(a, y_gpp_theta_a_beta_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_beta_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_beta_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(beta, " = 0.5") ), 
expression( paste(beta, " = 1") ),
expression( paste(beta, " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_0p5_a_beta_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_0p5_a_beta_123", type = c("jpg"))


## (c): k0 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
k0_1 = 0.5
k0_2 = 1
k0_3 = 2
alpha = beta = k1 = 1
y_gpp_theta_a_k0_1 = k0_1 * x^alpha + k1 / x^beta - (k0_1 + k1)
y_gpp_theta_a_k0_2 = k0_2 * x^alpha + k1 / x^beta - (k0_2 + k1)
y_gpp_theta_a_k0_3 = k0_3 * x^alpha + k1 / x^beta - (k0_3 + k1)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_k0_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(c)")
lines(a, y_gpp_theta_a_k0_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_k0_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_k0_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[0], " = 0.5") ), 
expression( paste(k[0], " = 1") ),
expression( paste(k[0], " = 2") )
)
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_0p5_a_k0_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_0p5_a_k0_123", type = c("jpg"))


## (d): k1 changes
rm(list=ls(all=TRUE))
x = seq(0.2, 5, by = 0.01)
theta = 0.5
a = theta * x
k1_1 = 0.5
k1_2 = 1
k1_3 = 2
alpha = beta = k0 = 1
# alpha = beta = 1; k0 = 2
y_gpp_theta_a_k1_1 = k0 * x^alpha + k1_1 / x^beta - (k0 + k1_1)
y_gpp_theta_a_k1_2 = k0 * x^alpha + k1_2 / x^beta - (k0 + k1_2)
y_gpp_theta_a_k1_3 = k0 * x^alpha + k1_3 / x^beta - (k0 + k1_3)

# mar = c(bottom, left, top, right)
dev.new()
lty = 1:3
col = c("blue", "red", "purple")
ylim = c(-0.5, 2.5)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y_gpp_theta_a_k1_1, ylim = ylim, xlab = expression( a ), ylab = expression( paste(L[p]^{group("(", list(alpha, beta, k[0], k[1]), ")")}, group("(", list(theta, a), ")")) ), type = "l", lwd = 4, sub = "(d)")
lines(a, y_gpp_theta_a_k1_1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y_gpp_theta_a_k1_2, lty = lty[2], col = col[2], lwd = 4)
lines(a, y_gpp_theta_a_k1_3, lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression( paste(k[1], " = 0.5") ), 
expression( paste(k[1], " = 1") ),
expression( paste(k[1], " = 2") )
)
legend("top", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/y_gpp_theta_0p5_a_k1_123", type = c("pdf"))
savePlot(filename = "figure/y_gpp_theta_0p5_a_k1_123", type = c("jpg"))



